;///////////////////////////////////////////////////////////////////////////////////
;This is the main module of satisfy project.
;The major function is "satisfy"
;To use it, just (load "satisfy.scm") and run (satisfy test)
;The satisfy function will assume a well-formated CNF input with maximum two
;repetition of same redundant variable in same clause.
;Satisfy call a "backtrack" which will implement the backtrack algorithm
;
;
;

(load "mergeterm.txt")
(load "probelist.txt")


(define getnextvar
	(lambda (varlist)
		(if (null? varlist)
			'()
			(if (eq? 'N (cdr (car varlist)))
				(car (car varlist))
				(getnextvar (cdr varlist))
			)
		)
	)
)				 


(define dosimplifylist
	(lambda (ls current)
		(if (getsymbol current)
			(simplifylist ((shrinklistwithsymbol current) ls))
			(simplifylist ((shrinklistwithsymbol (getnegatefromsymbol current)) ls))
		)
	)
)
				



(define dobacktrack
	(lambda (ls current)		
		(let ((result (dosimplifylist ls current)))
			(if (boolean? result)
				result
				(backtrack result gVarlist)
			)
		)
	)
)
			
;keep the local context

(define wrapdobacktrack
	(lambda (ls varlist current which)
		(begin
			(setsymbol current which)
			(let ((result1 (dobacktrack ls current)))
				(if (boolean? result1);must be false
					(begin 
						;(pp (list "backtracking...gVarlist" gVarlist "current=" current))
						(set! gVarlist varlist)
						(setsymbol current (not which))
						(let ((result2 (dobacktrack ls current)))
							(if (boolean? result2)
								(begin
									;(pp(list "backtracking after false current=" current "gVarlist=" gVarlist "gNewlist="gNewlist))									
										
									#f; unsatisfiable
								)
								result2
							)
						)
					)	
					result1											
				)
			)
		)
	)
)

(define checkvarboolean
	(lambda (current)
		(> (cdr(assq current gVarCountList)) 0)
	)
)


;
;The major function to implement backtrack
;the parameter "varlist" give the guide of which variable has been set with 
;truth value. And it is kept as private for each function framework
;
(define backtrack
	(lambda (ls varlist)
		(begin ;(pp (list "backtrack gVarlist="	gVarlist ))			
		(set! gVarlist varlist)
		(let ((current (getnextvar varlist)))
			(if (null? current)
				varlist; find satisfiable
				(wrapdobacktrack ls varlist current (checkvarboolean current))
			)
		))
	)
)

;The main function which test satisfiable of input string.
;
;
(define satisfy
	(lambda (ls)	
		(set! gVarlist (constructvarlistplus ls))
		(let ((result (simplifylist ls)))
			(if (boolean? result)
				#f
				(begin				
					;(pp (list "before backtrack, the gVarlist=" gVarlist))
					(backtrack (cdr ls) gVarlist)									
				)
			)
		)
	)
)
			
